/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import alma.acs.tmcdb.ContStartOptType;
import alma.acs.tmcdb.ContainerStartupOption;
import alma.obops.tmcdbgui.editors.ContainerStartupOptionEditor;

public class NewContainerStartupOptionPage extends WizardPage 
{
	private ContainerStartupOption _option;

	protected NewContainerStartupOptionPage(String pageName, ContainerStartupOption option) {
		super(pageName);
		_option = option;
		setTitle("New ContainerStartupOption");
		setDescription("Specify the initial basic details of the new ContainerStartupOption");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		/* Widgets */
		final Text   cNameText;
		final Combo  cTypeCombo;
		final Text   cValueText;

		parent.setLayout(new FillLayout());
		ScrolledComposite sc = new ScrolledComposite(parent, SWT.V_SCROLL | SWT.BORDER);
		sc.setExpandHorizontal(true);
		sc.setExpandVertical(true);

		Composite composite = new Composite(sc, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));

		/* Name */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label cNameLabel = new Label(composite, SWT.NONE);
		cNameLabel.setText("Name");
		cNameLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		cNameText = new Text(composite, SWT.BORDER);
		cNameText.setLayoutData(gd);

		/* Type */
		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label cProcTypeLabel = new Label(composite, SWT.NONE);
		cProcTypeLabel.setText("Type");
		cProcTypeLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		Composite c = new Composite(composite, SWT.CHECK);
		c.setLayoutData(gd);
		c.setLayout(new RowLayout());
		cTypeCombo = new Combo(c, SWT.DROP_DOWN | SWT.READ_ONLY );
		cTypeCombo.setData("type", "optionType");
		cTypeCombo.setItems(ContainerStartupOptionEditor.TYPES);
		ContainerStartupOptionEditor.selectOption(_option.getOptionType(), cTypeCombo);

		/* Value */
		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label cValueLabel = new Label(composite, SWT.NONE);
		cValueLabel.setText("Value");
		cValueLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		cValueText = new Text(composite, SWT.BORDER);
		cValueText.setLayoutData(gd);
		
		// Finally, calculate the minimum size so the scroll composite knows
		// when to start its role
		sc.setContent(composite);
		sc.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		// Listener for option name
		cNameText.addListener(SWT.KeyUp, new Listener() {
			public void handleEvent(Event event) {
				_option.setOptionName( cNameText.getText() );
				toggleIsComplete();
			}
		});
		// Listener for option type
		cTypeCombo.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}

			@Override
			public void widgetSelected(SelectionEvent e) {
				_option.setOptionType( ContStartOptType.valueOfForEnum(cTypeCombo.getItem(cTypeCombo.getSelectionIndex())));
				toggleIsComplete();			}
		});
		// Listener for option value
		cValueText.addListener(SWT.KeyUp, new Listener() {
			public void handleEvent(Event event) {
				_option.setOptionValue( cValueText.getText() );
				toggleIsComplete();
			}
		});

		setControl( composite );
		setPageComplete(false);
	}

	private void toggleIsComplete() {

		// Errors
		if( _option.getOptionName() == null || _option.getOptionName().trim().equals("")) {
			setErrorMessage("Name missing");
			setPageComplete(false);
		}
		else if ( _option.getOptionType() == null ) {
			setErrorMessage("Type missing");
			setPageComplete(false);
		}
		else if( _option.getOptionValue() == null || _option.getOptionValue().trim().equals("") ) {
			setErrorMessage("Value missing");
			setPageComplete(false);
		}
		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}

}
