/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.ConfigurationAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard page for adding a new configuration.
 * @author sharring
 */
public class NewConfigurationWizardPage extends WizardPage implements StatusListener
{
	private static final String DESCRIPTION_TEXT = "Please specify configuration's attributes";
	private static final String NEW_CONFIGURATION = "New Configuration";
	private final static String PAGE_NAME = "Create Configuration";
	private ConfigurationAttributesComposite configAttributesComposite;
	
	protected NewConfigurationWizardPage() 
	{
		super(PAGE_NAME);
		this.setTitle(NEW_CONFIGURATION);
		this.setDescription(DESCRIPTION_TEXT);
	}

	@Override
	public void createControl(Composite parent) 
	{
		this.configAttributesComposite = new ConfigurationAttributesComposite(parent, SWT.NONE, this, null, null);
		this.setControl(configAttributesComposite);
		this.setPageComplete(false);
	}
	
	public HwConfiguration getConfiguration() {
		HwConfiguration retVal = null;
		retVal =  configAttributesComposite.getConfiguration();
		return retVal;
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) 
	{
		this.setErrorMessage(newStatusMessage);
	}

	@Override
	public void notifyOfCompletion(boolean complete) 
	{
		this.setPageComplete(complete);
	}
	
}
