/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import alma.obops.tmcdbgui.handlers.NewConfigurationAction;

/**
 * Wizard for creating a new configuration.
 * @author sharring
 */
public class NewConfigurationWizard extends Wizard implements INewWizard 
{
	private NewConfigurationWizardPage newConfigPage;
	private NewConfigurationAction action;
	
	/**
	 * Constructor.
	 * @param callback the action which will perform the "work" for this wizard, after the wizard has collected 
	 *        the requisite information from the user.
	 */
	public NewConfigurationWizard(NewConfigurationAction callback) 
	{
		super();
		this.action = callback;
	}

	@Override
	public boolean performFinish() 
	{
		action.setConfiguration(newConfigPage.getConfiguration());
		return true;
	}

	@Override
	 /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() 
    {
        newConfigPage = new NewConfigurationWizardPage();
        addPage( newConfigPage );
    }

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) 
	{
		// noop
	}
}
