/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComputerWizard.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.ComputerProcessorType;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.editors.ComputerEditor;
import alma.obops.tmcdbgui.editors.inputs.ComputerEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard for creating a new {@link Computer} object.
 * 
 * If during the launching of this wizard a {@link HwConfiguration} was selected,
 * its associated SW configuration is used as the default configuration
 * for the new computer.
 * 
 * @author rtobar, Mar 4, 2010
 *
 */
public class NewComputerWizard extends Wizard implements INewWizard {

	private IWorkbench _workbench;
	private Computer _comp;
	private Configuration configuration;
	
	public NewComputerWizard(Configuration config)
	{
		this.configuration = config;
	}
	
	@Override
	public boolean performFinish() {

		_comp.setProcessorType(ComputerProcessorType.UNI);
		// Open the Computer editor with the new computer information
		ComputerEditorInput cei = new ComputerEditorInput(_comp);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(cei, ComputerEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {

		_workbench = workbench;
		_comp = new Computer();
		_comp.setDiskless(false);
		_comp.setRealTime(false);
		_comp.setConfiguration(configuration);
	}

	@Override
	public void addPages() {
		addPage(new NewComputerPage("New Computer", _comp));
	}

	
}
