/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComponentWizard.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import alma.acs.tmcdb.ComponentType;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.ComponentTypeConversationUtils;

/**
 * Wizard for creating a new {@link ComponentType} object.
 *
 * @author rtobar, Sep 7th, 2010
 *
 */
public class NewComponentTypeWizard extends Wizard implements INewWizard {

	private IWorkbench _workbench;
	private ComponentType _compType;

	@Override
	public boolean performFinish() {
		try {
			ComponentTypeConversationUtils.getInstance().saveOrUpdate(_compType);
		} catch(Exception e) {
			RcpUtils.errorMessage(e, _workbench.getActiveWorkbenchWindow().getShell(),
			  "Cannot create new Component Type",
			  "Unexpected exception while trying to create new Component Type '" + _compType.getIDL() + "'");
			return false;
		}
		return true;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_compType = new ComponentType();
	}

	@Override
	public void addPages() {
		addPage(new NewComponentTypePage("New Component Type", _compType));
	}
}
