/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComputerPage.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Computer;

/**
 * Wizard page for creation of a new {@link Computer} object.
 * 
 * This page is used the {@link NewComputerWizard}
 * 
 * @author rtobar, Mar 2, 2010
 */
public class NewComponentTypePage extends WizardPage {

	private ComponentType _compType;

	protected NewComponentTypePage(String pageName, ComponentType compType) {
		super(pageName);
		_compType = compType;
		setTitle("New Component Type");
		setDescription("Specify the IDL type for the new Component Type");
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		final Text idlText;

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* IDL */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label configurationLabel = new Label(composite, SWT.NONE);
		configurationLabel.setText("IDL");
		configurationLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 10;
		idlText = new Text(composite, SWT.BORDER);
		idlText.setLayoutData(gd);

		// Listener for computer name
		idlText.addListener(SWT.KeyUp, new Listener() {
			public void handleEvent(Event event) {
				_compType.setIDL( idlText.getText() );
				toggleIsComplete();
			}
		});

		setControl( composite );
		setPageComplete(false);
	}

	private void toggleIsComplete() {

		// Errors
		if( _compType.getIDL() == null || _compType.getIDL().trim().equals("") ) {
			setErrorMessage("IDL type missing");
			setPageComplete(false);
		}

		// Warnings
		else if( !_compType.getIDL().trim().matches("IDL:.*:1\\.0") ) {
			setMessage("IDL type should be of type 'IDL:<interfacePath>:1.0'", DialogPage.WARNING);
			setErrorMessage(null);
			setPageComplete(true);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}
}