/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.WorkbenchException;

import alma.acs.tmcdb.AcsService;
import alma.acs.tmcdb.AcsServiceServiceType;
import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.editors.AcsServiceEditor;
import alma.obops.tmcdbgui.editors.inputs.AcsServiceEditorInput;
import alma.obops.tmcdbgui.perspectives.SwConfigurationPerspective;

public class NewAcsServiceWizard extends Wizard implements INewWizard 
{
	private static final String PAGENAME = "New ACS Service description";
	private IWorkbench _workbench;
	private AcsService _service;
	private Computer _computer;
	private Configuration _configuration;

	/**
	 * @param compNames  Names of the available Components
	 */
	public NewAcsServiceWizard( Computer computer, Configuration configuration ) {
		this._computer = computer;
		this._configuration = configuration;
	}

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
	public void addPages() {
		WizardPage page = new NewAcsServicePage( PAGENAME, _service);
		addPage( page );
	}

	@Override
	public boolean performFinish() 
	{
		// Open the editor with the new object's information
		AcsServiceEditorInput cei = new AcsServiceEditorInput(_service);
		try {
			_workbench.getActiveWorkbenchWindow().getActivePage().openEditor(cei, AcsServiceEditor.ID);
			_workbench.showPerspective(SwConfigurationPerspective.ID, _workbench.getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_service = new AcsService();
		_service.setComputer(_computer);
		_service.setConfiguration(_configuration);
		_service.setServiceType(AcsServiceServiceType.NAMING);
	}

	/** 
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for( int i = 0; i < pages.length; i++ ) {
			if( !pages[i].isPageComplete() ) {
				return false;
			}
		}
		return true;
	}
}
