/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.Date;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.HolographyTowerAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;

public class HolographyTowerAttributesWizardPage extends WizardPage implements StatusListener
{
	private HolographyTowerAttributesComposite holographytowerAttributesComposite;
	private HwConfiguration configuration;
	
	protected HolographyTowerAttributesWizardPage(String pageName, HwConfiguration config) 
	{
		super(pageName);
		setTitle( pageName );
		setDescription( "Specify the holography tower's attributes" );
		this.configuration = config;
	}

	@Override
	public void createControl(Composite parent) 
	{
		holographytowerAttributesComposite = new HolographyTowerAttributesComposite(parent, SWT.None, this, configuration);
		this.setControl(holographytowerAttributesComposite);
		this.setPageComplete(false);
	}

	public Date getCommissionDate() 
	{
		Date retVal = null;
		retVal = holographytowerAttributesComposite.getCommissionDate();
		return retVal;
	}

	@Override
	public void notifyOfCompletion(boolean complete) 
	{
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) 
	{
		this.setErrorMessage(newStatusMessage);
	}

	public String getHolographyTowerName() {
		String retVal = null;
		retVal = holographytowerAttributesComposite.getHolographyTowerName();
		return retVal;
	}
	
	public Coordinate getPosition() {
		Coordinate retVal = null;
		retVal = holographytowerAttributesComposite.getPosition();
		return retVal;
	}
}
