/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.Date;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.FrontendAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard page for basic frontend attributes. 
 * @author sharring
 */
public class FrontendAttributesWizardPage extends WizardPage implements StatusListener
{
	private HwConfiguration configuration;
	private FrontendAttributesComposite frontendAttributesComposite;
	 
	protected FrontendAttributesWizardPage( String pageName, HwConfiguration config )
	{
		super(pageName);
		this.configuration = config;
		setTitle( pageName );
		setDescription( "Specify the frontend's attributes" );
	}

	@Override
	public void createControl(Composite parent) 
	{
		frontendAttributesComposite = new FrontendAttributesComposite(parent, SWT.None, this, configuration);
		this.setControl(frontendAttributesComposite);
		this.setPageComplete(false);
	}
	
	/**
	 * Getter for the new antenna's name.
	 * @return the new antenna's name.
	 */
	public String getName() 
	{
		String retVal = null;
		
		retVal = frontendAttributesComposite.getFrontendName();
		
		return retVal;
	}
	
	/**
	 * Getter for the new antenna's commission date.
	 * @return the new antenna's commission date.
	 */
	public Date getCommissionDate() 
	{
		Date retVal = null;
		
		retVal = frontendAttributesComposite.getCommissionDate();
		
		return retVal;
	}
	
	@Override
	public void notifyOfCompletion(boolean complete) 
	{
		this.setPageComplete(complete);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) 
	{
		this.setErrorMessage(newStatusMessage);
	}
}
