/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;
import alma.obops.tmcdbgui.utils.conversation.ComponentConversationUtils;

/**
 * Implementation of {@link ComponentProvider} that retrieves all components
 * that are associated with a given Configuration.
 *
 * @author rtobar, Apr 20th, 2011
 *
 */
public class ConfigurationComponentProvider implements ComponentProvider {

	private Configuration _config;

	public ConfigurationComponentProvider(Configuration config) {
		_config = config;
	}

	public List<Component> getComponents(EclipseProgressMonitor monitor) throws Exception {
		try {
			monitor.beginTask("Getting components for configuration", IProgressMonitor.UNKNOWN);
			ComponentConversationUtils.getInstance().hydrateComponents(_config);
			return new ArrayList<Component>(_config.getComponents());
		} catch (Exception e) {
			throw e;
		} finally {
			monitor.done();
		}
	}

}