/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComponentPage.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.ComponentType;
import alma.obops.tmcdbgui.dialogs.ComponentTypeSelectionDialog;
import alma.obops.tmcdbgui.dialogs.ComponentTypeSelectionDialogLabelProvider;

/**
 * Wizard page for creation of a new {@link Component} object.
 *
 * This page is used the {@link NewComponentWizard}
 *
 * @author rtobar, Mar 2, 2010
 */
public class ComponentTypeChooserPage extends WizardPage {

	private ComponentType _compType;

	protected ComponentTypeChooserPage(ComponentType compType) {
		super("Component Type Chooser");
		setTitle("Component Type Chooser");
		setDescription("Choose the component type for which you want to modify BACI properties");
		_compType = compType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));

		/* Component Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label compTypeLabel = new Label(composite, SWT.NONE);
		compTypeLabel.setText("Component Type");
		compTypeLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		final Text componentTypeIDL = new Text(composite, SWT.BORDER | SWT.SINGLE);
		componentTypeIDL.setText( _compType == null ? "" : _compType.getIDL() );
		componentTypeIDL.setEditable(false);
		componentTypeIDL.setLayoutData(gd);

		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Button browseCompTypes = new Button(composite, SWT.PUSH);
		browseCompTypes.setText("Browse...");
		browseCompTypes.setLayoutData(gd);


		// Setup the browser button and logic
		browseCompTypes.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				ElementListSelectionDialog d = new ComponentTypeSelectionDialog(getShell(), new ComponentTypeSelectionDialogLabelProvider());
				d.open();
				Object compTypes[] = d.getResult();
				if( compTypes != null && compTypes.length == 1 ) {
					_compType = (ComponentType)compTypes[0];
					componentTypeIDL.setText( _compType.getIDL() );
				}
				toggleIsComplete();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});

		setControl( composite );
		toggleIsComplete();
	}

	private void toggleIsComplete() {

		// Errors
		if( getComponentType() == null ) {
			setErrorMessage("Component Type missing");
			setPageComplete(false);
		}

		else {
			setErrorMessage(null);
			setMessage(null, DialogPage.WARNING);
			setPageComplete(true);
		}
	}

	public ComponentType getComponentType() {
		return _compType;
	}

}