/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.widgets.ComponentEditingComposite;

public class ComponentEditorPage extends WizardPage implements Listener 
{
	private ComponentEditingComposite editor;
	private IWorkbenchWindow _window;
	private Component tempComponent;
	private String[] properties;
	private Object[] values;
	private Configuration _configuration;
	
	protected ComponentEditorPage(IWorkbenchWindow window, Configuration config) {
		super("Component Editor");
		setTitle("Component editor");
		this._window = window;
		this._configuration = config;
		//setDescription("Select which fields you want to change with the checkboxes. Then, enter the desired value");
	}
	
	@Override
	public void handleEvent(Event e) 
	{
		properties = editor.getEnabledProperties();
		values = editor.getValuesForEnabledProperties();

		boolean completeFlag = false;
		int count = 0;
		if(null != values && (values.length == properties.length)) {
			completeFlag = true;
			for(Object val : values) 
			{
				if(val == null && !properties[count].equals(ComponentEditingComposite.XML_DOC_PROPERTY) || 
				  (val instanceof String && !properties[count].equals(ComponentEditingComposite.XML_DOC_PROPERTY) && ((String)val).equals("")) ) 
				{
					completeFlag = false;
					count++;
					continue;
				}
				count++;
			}
		}
		completeFlag &= (properties.length > 0);
		setPageComplete( completeFlag );		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		tempComponent = new Component();
		tempComponent.setConfiguration(this._configuration);
		editor = new ComponentEditingComposite(null, composite, SWT.NONE, tempComponent, _window, this);
		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
		editor.setLayoutData(gd);

		setControl( composite );
		setPageComplete(false);
	}

	public String[] getObjectProperties() {
		return properties;
	}

	public Object[] getPropertiesValues() {
		return values;
	}
	
	public void setComponent(Component comp) {
		editor.setComponent(comp);		
	}
}
