/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.ArrayList;
import java.util.List;

import alma.acs.tmcdb.BACIProperty;
import alma.acs.tmcdb.Component;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;
import alma.obops.tmcdbgui.utils.conversation.BaciConversationUtils;

/**
 * Implementation of {@link BACIPropertiesProvider} that gets a list of only the
 * <b>common</b> BACI properties for the given list of components.
 *
 * @author rtobar, Apr. 20th, 2011
 *
 */
public class CommonBACIPropertiesProvider implements BACIPropertiesProvider {

	private Component[] _components;

	public CommonBACIPropertiesProvider(Component[] components) {
		_components = components;
	}

	@Override
	public List<BACIProperty> getBACIProperties(EclipseProgressMonitor monitor) throws Exception {

		BACIProperty prop;
		List<String> props;
		props = BaciConversationUtils.getInstance().findBACIPropertyNamesForComponents(_components, monitor);

		List<BACIProperty> fProps = new ArrayList<BACIProperty>();
		for (String baciProperty : props) {
			prop = new BACIProperty();
			prop.setPropertyName(baciProperty);
			fProps.add(prop);
		}

		return fProps;
	}

}
