/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.CloneAntennaAction;
import alma.tmcdb.domain.Antenna;

/**
 * Simple wizard used for prompting for info (e.g. the name) about a cloned antenna.
 * @author sharring
 */
public class CloneAntennaWizard extends Wizard 
{
	private static final String WIZARD_PAGENAME = "Clone antenna";
	private CloneAntennaAction action;
	private CloneAntennaWizardPage wizardPage;
	private Antenna antenna;
	
	/**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new antenna, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new antenna will 'live'.
     * @param type the type of the antenna which is being cloned.
     * @param originalAntennaName the name of the to-be-cloned antenna.
     */
    public CloneAntennaWizard(CloneAntennaAction callback, Antenna antennaToClone) 
    {
        this.action = callback;
        this.antenna = antennaToClone;
    }
    
    @Override
    public void addPages()
    {
    	wizardPage = new CloneAntennaWizardPage(WIZARD_PAGENAME, antenna);
    	addPage(wizardPage);
    }
    
	@Override
	public boolean performFinish() {
    	action.setName( wizardPage.getName() );
		return true;
	}

}
