/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.Pad;

/**
 * Wizard to choose a pad, used e.g. by the AssignAntennaToPadAction.
 * @author sharring
 */
public class ChoosePadWizard extends Wizard 
{
	private ChoosePadWizardPage padChooserPage;
	private ChooseConfigurationWizardPage configChooserPage;
	private HwConfiguration config;
	
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new Assembly, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new Assembly will 'live'.
     * @param asstype 
     */
    public ChoosePadWizard( HwConfiguration config ) 
    {
        this.config = config;
    }
    
	public Pad getPad()
	{
		return padChooserPage.getPad();
	}
	
	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() 
    {
    	this.padChooserPage = new ChoosePadWizardPage( "Choose pad", config );
    	this.configChooserPage = new ChooseConfigurationWizardPage("Choose configuration", padChooserPage, config);
        
    	// config chooser page precedes pad chooser page
    	addPage( configChooserPage );
    	addPage( padChooserPage );
    }
    
	@Override
	public boolean performFinish() 
	{
		return true;
	}

}
