/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) NRAO - National Radio Astronomy Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ChooseNotificationServiceWizardPage extends WizardPage 
{
	private String[] items;
	private String notificationServiceName;
	
	public ChooseNotificationServiceWizardPage(String additionalDescription, String[] items) {
		super("Choose Notification Service");
		this.items = items;
		setTitle("Choose Notification Service");
		StringBuffer descriptionStringBuffer = new StringBuffer("Specify the notification service ");
		if(additionalDescription != null) {
			descriptionStringBuffer.append(additionalDescription);
		}
		
		setDescription(descriptionStringBuffer.toString());
	}

	@Override
	public void createControl(Composite parent) 
	{
		NotificationServiceChooserComposite comp = new NotificationServiceChooserComposite(parent, SWT.NONE);
		this.setControl(comp);
	}
	
	private class NotificationServiceChooserComposite extends Composite
	{
		private Combo typeCombo;
		
		public NotificationServiceChooserComposite(Composite parent, int style) 
		{
			super(parent, style);
			createControl();
		}

		private void createControl() 
		{
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 2;
			this.setLayout(gridLayout);

			GridData gd = new GridData();
			gd.grabExcessHorizontalSpace = false;

			Label typeLabel = new Label(this, SWT.NONE);
			typeLabel.setText("NotificationService: ");
			typeLabel.setLayoutData(gd);

			typeCombo = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);

			typeCombo.setItems(items);
			typeCombo.setLayoutData(new GridData());
			typeCombo.setText("Select notification service");
			typeCombo.setItems(items);

			typeCombo.addSelectionListener(new SelectionListener() 
			{
				@Override
				public void widgetDefaultSelected(SelectionEvent selEvt) {
					widgetSelected(selEvt);
				}

				@Override
				public void widgetSelected(SelectionEvent selEvt) {
					setPageComplete(true);
					String item = typeCombo.getItem(typeCombo.getSelectionIndex());
					notificationServiceName = item;
				}
			});
		}
	}
	
	public String getNotificationServiceName()
	{
		return this.notificationServiceName;
	}
}
