/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

import alma.acs.tmcdb.BACIProperty;
import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;
import alma.obops.tmcdbgui.utils.conversation.BACIPropertyConversationUtils;

public class ByExampleBACIPropertyProvider implements BACIPropertiesProvider {

	private String[] _fields;
	private Object[] _values;
	private Configuration _config;

	public ByExampleBACIPropertyProvider(String[] fields, Object[] values, Configuration config) {
		_fields = fields;
		_values = values;
		_config = config;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<BACIProperty> getBACIProperties(EclipseProgressMonitor monitor)
			throws Exception {

		List<Object> criteria = new ArrayList<Object>();
		for(int i=0; i!=_fields.length; i++)
			criteria.add( Restrictions.eq(_fields[i], _values[i]));

		DetachedCriteria dc = DetachedCriteria.forClass(Component.class)
		  .add( Restrictions.eq("configuration", _config))
		  .setProjection(Projections.property("componentId"));
		criteria.add( Subqueries.propertyIn("component", dc) );

		monitor.beginTask("Searching for compatible BACI properties", -1);
		List<BACIProperty> props = (List<BACIProperty>) BACIPropertyConversationUtils.getInstance().find(criteria, null);

		monitor.beginTask("Getting BACI properties details", props.size());
		for(BACIProperty prop: props) {
			BACIPropertyConversationUtils.getInstance().hydrateComponent(prop);
			monitor.worked(1);
		}
		monitor.done();

		return props;
	}

}
