/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchWindow;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.ComponentType;
import alma.acs.tmcdb.Configuration;
import alma.obops.dam.utils.ProgressMonitor;
import alma.obops.tmcdbgui.rcp.TmcdbExplorer;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;
import alma.obops.tmcdbgui.utils.conversation.ComponentConversationUtils;

public class BulkComponentChangesWizard extends Wizard 
{
	private ComponentTypeChooserPage componentTypeChooserPage;
	private ComponentChooserPageWithoutBaciProperties componentChooserPage;
	private ComponentEditorPage componentEditorPage;
	private IWorkbenchWindow _window;
	
	private ComponentType _compType;
	private Configuration _config;
	
	public BulkComponentChangesWizard(Configuration config, IWorkbenchWindow win) {
		_config   = config;
		setNeedsProgressMonitor(true);
		this._window = win;
	}

	@Override
	public boolean performFinish()
	{
		Job job = new Job("Updating Components") 
		{
			protected IStatus run(IProgressMonitor monitor) 
			{

				Component[] selectedComponents = componentChooserPage.getComponents();

				// With the selected components			
				String[] objectProperties = componentEditorPage.getObjectProperties();
				Object[] values = componentEditorPage.getPropertiesValues();

				ProgressMonitor eclipseMonitor = new EclipseProgressMonitor(monitor);

				try {
					ComponentConversationUtils.getInstance().bulkUpdateComponents(selectedComponents,	objectProperties, values, eclipseMonitor);
				} catch(Exception e) {
					e.printStackTrace();
					return new Status(IStatus.ERROR, TmcdbExplorer.PLUGIN_ID, e.getMessage());
				}

				return Status.OK_STATUS;
			}
		};

		job.setUser(true);
		job.schedule();
        return true;
	}
	
	 /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages()
    {
    	componentTypeChooserPage = new ComponentTypeChooserPage(_compType);
	componentChooserPage = new ComponentChooserPageWithoutBaciProperties(componentTypeChooserPage, _config);
    	componentEditorPage = new ComponentEditorPage(_window, _config);

    	addPage( componentTypeChooserPage );
        addPage( componentChooserPage );
        addPage( componentEditorPage );
    }

	@Override
	public IWizardPage getNextPage(IWizardPage page) 
	{
		IWizardPage next = super.getNextPage(page);
		return next;
	}
	
}
