/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BACIPropertiesSearchCriteriaChooserPage extends WizardPage implements SelectionListener {

	public enum SearchCriteria {
		BY_COMPONENT_TYPE,
		BY_COMPONENT_NAME,
		BY_BACIPROPERTY_CONTENTS
	}

	private SearchCriteria option;

	public BACIPropertiesSearchCriteriaChooserPage () {
		super("Select criteria");
		setTitle("Select criteria");
		setDescription("Choose which method you will use to select the desired BACI properties to be changed");
	}

	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		GridData gd = new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_BEGINNING, true, false);
		Composite buttonGroup = new Composite(composite, SWT.NONE);
		buttonGroup.setLayoutData(gd);
		buttonGroup.setLayout(new GridLayout(1, true));

		gd = new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_BEGINNING, true, false);
		Button r1 = new Button(buttonGroup, SWT.RADIO);
		r1.setData(SearchCriteria.BY_COMPONENT_TYPE);
		r1.addSelectionListener(this);
		r1.setText("Select Component Type, then Components, and finally BACI Properties");
		r1.setLayoutData(gd);

		gd = new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_BEGINNING, true, false);
		Button r2 = new Button(buttonGroup, SWT.RADIO);
		r2.setData(SearchCriteria.BY_COMPONENT_NAME);
		r2.addSelectionListener(this);
		r2.setText("Select Components by name, then which BACI properties to edit");
		r2.setLayoutData(gd);

		gd = new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_BEGINNING, true, false);
		Button r3 = new Button(buttonGroup, SWT.RADIO);
		r3.setData(SearchCriteria.BY_BACIPROPERTY_CONTENTS);
		r3.addSelectionListener(this);
		r3.setText("Select which BACI properties will be changed searching 'by example'");
		r3.setLayoutData(gd);

		setPageComplete(false);
		setControl(composite);
	}

	@Override
	public void widgetSelected(SelectionEvent e) {

		// only hear selection, not un-selections
		Button b = (Button)e.widget;
		if( !b.getSelection() )
			return;

		option = (SearchCriteria)b.getData();
		setPageComplete(true);
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}

	public SearchCriteria getSearchCriteria() {
		return option;
	}
}
