/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.List;

import alma.acs.tmcdb.BACIProperty;
import alma.obops.tmcdbgui.utils.EclipseProgressMonitor;

/**
 * Interface for classes that provide a list of BACI properties. This interface is
 * used in the {@link BACIPropertiesChooserPage} wizard page.
 *
 * @author rtobar, Apr. 20th, 2011
 *
 */
public interface BACIPropertiesProvider {

	/**
	 * Return the list of BACI properties that this class is suppose to deliver
	 * to the requester.
	 *
	 * @param monitor An eclipse monitor that might be used to inform the
	 *     progress of the requests
	 * @return A list of {@link BACIProperty}s
	 */
	public List<BACIProperty> getBACIProperties(EclipseProgressMonitor monitor) throws Exception;

}