/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * NewComponentPage.java
 */
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import alma.acs.tmcdb.BACIProperty;
import alma.acs.tmcdb.Component;
import alma.obops.tmcdbgui.widgets.BACIPropertyEditingComposite;

/**
 * Wizard page for creation of a new {@link Component} object.
 *
 * This page is used the {@link NewComponentWizard}
 *
 * @author rtobar, Mar 2, 2010
 */
public class BACIPropertiesEditorPage extends WizardPage implements Listener {

	private BACIPropertyEditingComposite editor;
	private String[] properties;
	private Object[] values;

	protected BACIPropertiesEditorPage(String title, String description) {
		super(title);
		setTitle(title);
		setDescription(description);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		// For using the BACIPropertyEditingComposite we need a real hydrated BACI Property, let's get one of them...
		editor = new BACIPropertyEditingComposite(null, composite, SWT.NONE, null, this);
		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
		editor.setLayoutData(gd);

		setControl( composite );
		setPageComplete(false);
	}

	public String[] getObjectProperties() {
		return properties;
	}

	public Object[] getPropertiesValues() {
		return values;
	}

	@Override
	public void handleEvent(Event e) {

		// If we hear a selection from one of the checkboxes, we update the information
		// about our available widgets
		if( e.type == SWT.Selection &&
		       e.widget instanceof Button &&
		      (e.widget.getStyle() & SWT.CHECK) == SWT.CHECK &&
		       e.widget.getData(BACIPropertyEditingComposite.WIDGET_ENABLER) != null &&
		       e.widget.getData(BACIPropertyEditingComposite.WIDGET_ENABLER).equals(true) )
			properties = editor.getEnabledProperties();

		// If we hear anything else, it's an event coming from the widgets themselves: update the values then
		else
			values = editor.getValuesForEnabledProperties();

		setPageComplete( properties.length > 0 );		
	}

	public void setBACIProperty(BACIProperty baciProperty) {
		editor.setBACIProperty(baciProperty);		
	}
}