/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import java.util.Date;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.AntennaAttributesComposite;
import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.tmcdb.domain.AntennaType;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard page to gather basic data about a new antenna, including attributes such as name, type, position, offset.
 * @author sharring
 */
public class AntennaAttributesWizardPage extends WizardPage implements StatusListener
{	
    private AntennaAttributesComposite antennaAttributesComposite;
    private HwConfiguration configuration;

	/**
	 * Constructor.
	 * @param pageName the name of the wizard page.
	 * @param config the configuration in which the new antenna will 'live'.
	 */
	protected AntennaAttributesWizardPage( String pageName, HwConfiguration config) 
	{
		super(pageName);
		this.configuration = config;
		setTitle( pageName );
		setDescription( "Specify the antenna's name & physical attributes" );
	}
	
	/**
	 * Getter for the new antenna's type.
	 * @return the type of the new antenna.
	 */
	public AntennaType getAntennaType() 
	{
		AntennaType retVal;
	
		retVal = antennaAttributesComposite.getAntennaType();
		
		return retVal;
	}

	/**
	 * Getter for the new antenna's commission date.
	 * @return the new antenna's commission date.
	 */
	public Date getCommissionDate() 
	{
		Date retVal = null;
		
		retVal = antennaAttributesComposite.getCommissionDate();
		
		return retVal;
	}

	/**
	 * Getter for the new antenna's diameter.
	 * @return the new antenna's diameter.
	 */
	public Double getDiameter() 
	{
		Double retVal = null;
		
		retVal = antennaAttributesComposite.getDiameter();
		
		return retVal;
	}

	/**
	 * Getter for the new antenna's name.
	 * @return the new antenna's name.
	 */
	public String getName() 
	{
		String retVal = null;
		
		retVal = antennaAttributesComposite.getAntennaName();
		
		return retVal;
	}

	/**
	 * Getter for the new antenna's offset (x offset; y, z are ignored).
	 * @return the new antenna's offset.
	 */
	public Coordinate getOffset() 
	{
		Coordinate retVal;
		
		retVal = antennaAttributesComposite.getOffset();
		
		return retVal;
	}
	
	/**
	 * Getter for the new antenna's position.
	 * @return the position of the new antenna.
	 */
	public Coordinate getPosition() 
	{
		Coordinate retVal;
	
		retVal = antennaAttributesComposite.getPosition();
		
		return retVal;
	}

	@Override
	public void createControl(Composite parent) {
		antennaAttributesComposite = new AntennaAttributesComposite(parent, SWT.None, this, configuration);
		this.setControl(antennaAttributesComposite);
		this.setPageComplete(false);
	}

	@Override
	public void updateErrorStatus(String newStatusMessage) 
	{
		this.setErrorMessage(newStatusMessage);
	}	
	
	@Override
	public void notifyOfCompletion(boolean complete) 
	{
		this.setPageComplete(complete);
	}

	public Integer getLoOffsetting() {
		Integer retVal;
		
		retVal = antennaAttributesComposite.getLoOffsetting();
		
		return retVal;
	}

	public Integer getWalshSequence() {
		Integer retVal;
		
		retVal = antennaAttributesComposite.getWalshSequence();
		
		return retVal;
	}

	public Integer getCorrelatorInputBaseline() {
		Integer retVal;
		
		retVal = antennaAttributesComposite.getCaiBaseline();
		
		return retVal;
	}
	
	public Integer getCorrelatorInputAca() {
		Integer retVal;
		
		retVal = antennaAttributesComposite.getCaiAca();
		
		return retVal;
	}
}
