/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.IAssignNewWeatherStationAttributes;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard for creation of a new weather station.
 * @author sharring
 */
public class AddWeatherStationWizard extends Wizard 
{
	private static final String WEATHERSTATION_ATTRIBUTES_PAGENAME = "New weather station";
	private HwConfiguration config;
	
    protected IAssignNewWeatherStationAttributes action;
    protected WeatherStationAttributesWizardPage attributesPage;
	
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new WeatherStation, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new WeatherStation will 'live'.
     */
    public AddWeatherStationWizard( IAssignNewWeatherStationAttributes callback, HwConfiguration config ) {
        this.action = callback;
        this.config = config;
    }

    /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() {
    	this.attributesPage = new WeatherStationAttributesWizardPage( WEATHERSTATION_ATTRIBUTES_PAGENAME, config);
        addPage( attributesPage );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() 
    {
        action.setWeatherStationName( attributesPage.getWeatherStationName() );
        action.setCommissionDate( attributesPage.getCommissionDate() );
        return true;
    }
}
