/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.AddPadAction;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard for adding a new antenna pad.
 * @author sharring
 */
public class AddPadWizard extends Wizard 
{
	private final static String PAD_ATTRIBUTES_PAGENAME = "Pad attributes";
	private HwConfiguration configuration;
	private AddPadAction action;
	private PadAttributesWizardPage attributesPage;
	
	/**
	 * Constructor.
	 * @param callback the action which will perform the "work" for this wizard, after the wizard has collected 
	 *        the requisite information from the user.
	 * @param config the configuration in which the new antenna pad will reside.
	 */
	public AddPadWizard(AddPadAction callback, HwConfiguration config) 
	{
		super();
		this.configuration = config;
		this.action = callback;
	}

	@Override
	public boolean performFinish() 
	{
		action.setName( attributesPage.getPadName() );
		action.setPosition( attributesPage.getPosition() );
		action.setCommissionDate( attributesPage.getCommissionDate() );
		action.setCableDelay(attributesPage.getCableDelay());
		return true;
	}

	@Override
	 /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() 
    {
        attributesPage = new PadAttributesWizardPage( PAD_ATTRIBUTES_PAGENAME, configuration );
        addPage( attributesPage );
    }
}
