/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.IAssignNewHolographyTowerAttributes;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard to create a new holography tower base element.
 * @author sharring
 */
public class AddHolographyTowerWizard extends Wizard 
{
	private static final String HOLOGRAPHYTOWER_ATTRIBUTES_PAGENAME = "New Holography Tower";
	private HwConfiguration config;
    protected IAssignNewHolographyTowerAttributes action;
    protected HolographyTowerAttributesWizardPage attributesPage;
	
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new HolographyTower, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new HolographyTower will 'live'.
     */
    public AddHolographyTowerWizard( IAssignNewHolographyTowerAttributes callback, HwConfiguration config ) 
    {
        this.action = callback;
        this.config = config;
    }

    /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() 
    {
    	this.attributesPage = new HolographyTowerAttributesWizardPage( HOLOGRAPHYTOWER_ATTRIBUTES_PAGENAME, config );
        addPage( attributesPage );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() 
    {
        action.setHolographyTowerName( attributesPage.getHolographyTowerName() );
        action.setCommissionDate( attributesPage.getCommissionDate() );
        action.setPosition(attributesPage.getPosition());
        return true;
    }
}
