/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.IAssignNewFrontendAttributes;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard to add a frontend to a configuration.
 * @author sharring
 */
public class AddFrontendWizard extends Wizard 
{
	private static final String FRONTEND_ATTRIBUTES_PAGENAME = "New Frontend";
	private HwConfiguration config;
    protected IAssignNewFrontendAttributes action;
    protected FrontendAttributesWizardPage attributesPage;
	
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new Frontend, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new Frontend will 'live'.
     */
    public AddFrontendWizard( IAssignNewFrontendAttributes callback, HwConfiguration config ) {
        this.action = callback;
        this.config = config;
    }

    /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() {
    	this.attributesPage = new FrontendAttributesWizardPage( FRONTEND_ATTRIBUTES_PAGENAME, config );
        addPage( attributesPage );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() 
    {
        action.setName( attributesPage.getName() );
        action.setCommissionDate( attributesPage.getCommissionDate() );
        return true;
    }
}
