/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.StartupScenario;

public class AddBaseElementStartupsWizard extends Wizard implements INewWizard 
{
	private ChooseBaseElementsWizardPage baseElementChooserPage;
	private ChooseConfigurationWizardPage configurationChooserPage;
	private StartupScenario destinationStartupScenario;
	
	public AddBaseElementStartupsWizard(StartupScenario destinationStartupScenario)
	{
		this.destinationStartupScenario = destinationStartupScenario;
	}
	
	@Override
	public boolean performFinish() 
	{
		return true;
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) 
	{
		// noop
	}

	@Override
	public void addPages() 
	{
		baseElementChooserPage = new ChooseBaseElementsWizardPage("Choose base elements", null, destinationStartupScenario);
		configurationChooserPage = new ChooseConfigurationWizardPage("Choose configuration", baseElementChooserPage, destinationStartupScenario.getConfiguration());
		addPage(configurationChooserPage);
		addPage(baseElementChooserPage);
	}
	
	public BaseElement[] getBaseElements() 
	{
		return baseElementChooserPage.getBaseElements();
	}
}
