/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.IAssignNewAssemblyAttributes;
import alma.tmcdb.domain.AssemblyType;
import alma.tmcdb.domain.HwConfiguration;

public class AddAssemblyWizard extends Wizard 
{
	private static final String ASSEMBLY_ATTRIBUTES_PAGENAME = "Create a new Assembly";
	private static final String ASSEMBLY_TYPE_PAGENAME = "Choose assembly type for new Assembly";
	private HwConfiguration config;
    protected IAssignNewAssemblyAttributes action;
    protected AssemblyAttributesWizardPage attributesPage;
    private AssemblyTypeChooserWizardPage assemblyTypePage;
    private AssemblyType assemblyType;
	
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new Assembly, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new Assembly will 'live'.
     * @param asstype 
     */
    public AddAssemblyWizard( IAssignNewAssemblyAttributes callback, HwConfiguration config, AssemblyType asstype ) 
    {
        this.action = callback;
        this.config = config;
        this.assemblyType = asstype;
    }

	/** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() 
    {
    	this.attributesPage = new AssemblyAttributesWizardPage( ASSEMBLY_ATTRIBUTES_PAGENAME, config );
    	this.assemblyTypePage = new AssemblyTypeChooserWizardPage( ASSEMBLY_TYPE_PAGENAME, attributesPage, assemblyType);
        
    	// type page precedes attributes page
    	addPage(assemblyTypePage);
    	addPage( attributesPage );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() 
    {
        action.setSerialNumber( attributesPage.getSerialNumber() );
        action.setAssemblyType(attributesPage.getAssemblyType());
        return true;
    }
    
    public void setConfiguration(HwConfiguration config)
    {
    	this.attributesPage.setConfiguration(config);
    }
}
