/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.wizards;

import org.eclipse.jface.wizard.Wizard;

import alma.obops.tmcdbgui.handlers.IAssignNewAntennaAttributes;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Wizard to add an antenna to a configuration.
 * @author sharring
 */
public class AddAntennaWizard extends Wizard 
{
	private static final String ANTENNA_ATTRIBUTES_PAGENAME = "New Antenna";
	private HwConfiguration config;
    protected IAssignNewAntennaAttributes action;
    protected AntennaAttributesWizardPage attributesPage;
    
    /**
     * Constructor.
     * @param callback the action which performs the actual task of adding a new antenna, after the wizard
     * has acquired all the pertinent information from the user.
     * @param config the Configuration in which the new antenna will 'live'.
     */
    public AddAntennaWizard( IAssignNewAntennaAttributes callback, HwConfiguration config ) {
        this.action = callback;
        this.config = config;
    }

    /** @see org.eclipse.jface.wizard.Wizard#addPages() */
    public void addPages() {
    	this.attributesPage = new AntennaAttributesWizardPage( ANTENNA_ATTRIBUTES_PAGENAME, config );
        addPage( attributesPage );
    }

    /** @see org.eclipse.jface.wizard.Wizard#performFinish()*/
    public boolean performFinish() 
    {
        action.setName( attributesPage.getName() );
        action.setType( attributesPage.getAntennaType() );
        action.setPosition( attributesPage.getPosition() );
        action.setOffset( attributesPage.getOffset() );
        action.setDiameter( attributesPage.getDiameter() );
        action.setCommissionDate( attributesPage.getCommissionDate() );
        action.setCableDelay( 0.0 );
        action.setLoOffsetting( attributesPage.getLoOffsetting());
        action.setWalshSequence( attributesPage.getWalshSequence());
        action.setCorrelatorInputBaseline( attributesPage.getCorrelatorInputBaseline());
        action.setCorrelatorInputAca( attributesPage.getCorrelatorInputAca());
        return true;
    }
}
