/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets.support;

/**
 * Interface for publishing status updates to interested observers.
 * @author sharring
 */
public interface StatusPublisher 
{
   /**
    * Adds a listener for status changes.
    * @param listener the status listener to add.
    */
   public void addStatusListener(StatusListener listener);

   /**
    * Removes a listener for status changes.
    * @param listener the status listener to remove.
    */
   public void removeStatusListener(StatusListener listener);

   /**
    * Publishes changes in status to interested parties.
    */
   public void publishStatusChange();

   /**
    * Notifies interested parties that the UI item being observed is now complete.
    */
   public void notifyListenersOfCompletion(boolean complete);
}
