/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets.support;

import alma.tmcdb.domain.Pad;

/**
 * Interface that can be implemented by publishers which notify listeners of changes in pad (selection/assignment).
 * @author sharring
 */
public interface PadPublisher 
{
	/**
	    * Publishes an Pad (e.g. selection) change.
	    * @param newPad the new antenna (e.g. selection).
	    */
	   public void publishPad(Pad newPad);

	   /**
	    * Adds an Pad listener, which will be notified when
	    * an Pad (e.g. selection) changes.
	    * @param listener the listener to add.
	    */
	   public void addPadListener(PadListener listener);

	   /**
	    * Removes an Pad listener.
	    * @param listener the listener to remove.
	    */
	   public void removePadListener(PadListener listener);
}
