/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets.support;

/**
 * Interface which can be implemented by classes that wish to publish
 * changes to their dirty state to interested listeners.
 * 
 * @author sharring
 * @see DirtyListener
 */
public interface DirtyPublisher 
{
	/**
	 * Adds a listener, which will be notified when the dirty state has changed.
	 * @param listener the listener to be notified upon dirty state changing.
	 */
	public void addDirtyListener(DirtyListener listener);
	
	/**
	 * Removes a dirty listener.
	 * @param listener the listener to remove.
	 */
	public void removeDirtyListener(DirtyListener listener);
	
	/**
	 * Notifies all listeners that the dirty state has changed.
	 */
	public void notifyDirtyListeners();
	
	/**
	 * Sets the dirty state & notifies listeners, if any.
	 * @param dirty the new state of dirtiness.
	 */
	public void setDirty(boolean dirty);

}
