/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets.support;

import alma.obops.tmcdbgui.widgets.IAntennaToPadConfigurer;
import alma.tmcdb.domain.AntennaToPad;

/**
 * Convenience interface for decoupling publisher/subscribers that need to be aware of changes to an antenna to pad mapping.
 * @author sharring
 */
public interface AntennaToPadPublisher 
{
	/**
	 * Notifies listeners, if any, that the a2p has changed.
	 * @param a2p the new antenna to pad mapping.
	 */
	public void publishAntennaToPad(AntennaToPad a2p);
	
	/**
	 * Adds a listener, which will be notified when the antenna to pad mapping changes.
	 * @param listener the new listener to add.
	 */
	public void addAntennaToPadListener(IAntennaToPadConfigurer listener);
	
	/**
	 * Removes a listener from the list of interested parties, listening for changes to the antenna to pad mapping.
	 * @param listener the listener to remove.
	 */
	public void removeAntennaToPadListener(IAntennaToPadConfigurer listener);
}
