/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets.support;

import alma.tmcdb.domain.Antenna;

/**
 * Interface for publishing changes to antennas (e.g. selections)
 * @author sharring
 */
public interface AntennaPublisher 
{
   /**
    * Publishes an antenna (e.g. selection) change.
    * @param newAntenna the new antenna (e.g. selection).
    */
   public void publishAntenna(Antenna newAntenna);

   /**
    * Adds an antenna listener, which will be notified when
    * an antenna (e.g. selection) changes.
    * @param listener the listener to add.
    */
   public void addAntennaListener(AntennaListener listener);

   /**
    * Removes an antenna listener.
    * @param listener the listener to remove.
    */
   public void removeAntennaListener(AntennaListener listener);
}
