/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.widgets.Composite;

import alma.obops.tmcdbgui.widgets.support.StatusListener;
import alma.obops.tmcdbgui.widgets.support.StatusPublisher;

/**
 * Adapter base class (widget) for any composite which wishes to be a status publisher.
 * @author sharring
 * @see StatusPublisher
 */
public class StatusPublishingComposite extends DirtyPublishingComposite implements StatusPublisher
{
   protected List<StatusListener> listenersOfStatus = new ArrayList<StatusListener>();
   protected String status;
   
   /**
    * Constructor.
    * @param parent the parent composite.
    * @param style the style for this composite.
    */
   public StatusPublishingComposite(Composite parent, int style) 
   {
      super(parent, style);
   }

   @Override
   public void addStatusListener(StatusListener listener) 
   {
	  if(null != listener) {
		  this.listenersOfStatus.add(listener);
	  }
   }

   @Override
   public void removeStatusListener(StatusListener listener) 
   {
	  if(null != listener) {
		  this.listenersOfStatus.remove(listener);
	  }
   }

   @Override
   public void publishStatusChange()
   {
      for(StatusListener listener: listenersOfStatus) 
      {
         listener.updateErrorStatus(this.getStatus());
      }
   }
   
   /** 
    * Getter for the status.
    * @return the status (string)
    */
   public String getStatus()
   {
      return this.status;
   }
   
   /**
    * Setter for the status.
    * @param newStatus the new status.
    */
   public void setStatus(String newStatus)
   {
      this.status = newStatus;
      publishStatusChange();
   }

   @Override
   public void notifyListenersOfCompletion(boolean completed) 
   {
      for(StatusListener listener: listenersOfStatus) 
      {
         listener.notifyOfCompletion(completed);
      }
   }
}
