/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.tmcdbgui.widgets;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;

import alma.obops.tmcdbgui.views.providers.SwDeploymentTreeLabelProvider;

/**
 * Useful utility class used by delete actions.
 * @author sharring
 */
public class DeleteMessageDialog extends MessageDialog 
{
	private TableViewer viewer;
	private Object[]    objectsToDelete;

	public DeleteMessageDialog(IWorkbenchWindow window, Object[] objectsToDelete) {
		super(window.getShell(), "Confirm delete", null,
				"Are you sure you want to delete the following objects?",
				MessageDialog.CONFIRM,
				new String[] { IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL},
				0);
		this.objectsToDelete = objectsToDelete;
	}

	@Override
	protected Control createCustomArea(Composite parent) {

		GridData gd = new GridData();
		gd.grabExcessHorizontalSpace = true;
		gd.horizontalAlignment = GridData.CENTER;
		gd.heightHint = 200;
		ScrolledComposite sc = new ScrolledComposite(parent, SWT.V_SCROLL | SWT.BORDER);
		sc.setExpandVertical(true);
		sc.setExpandHorizontal(true);
		sc.setLayoutData(gd);

		Composite composite = new Composite(sc, SWT.NONE);
		composite.setLayout(new GridLayout());

		viewer = new TableViewer(composite);
		viewer.setContentProvider(new IStructuredContentProvider() {
			private Object[] objectsToBeDeleted;
			public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
				objectsToBeDeleted = (Object[])newInput;
			}
			public void dispose() {}
			public Object[] getElements(Object inputElement) {
				return objectsToBeDeleted;
			}
		});
		viewer.setLabelProvider(new SwDeploymentTreeLabelProvider());
		viewer.setSorter(new ViewerSorter());
		viewer.setInput(objectsToDelete);

		sc.setContent(composite);
		sc.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		return composite;
	}

}
