/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import alma.acs.tmcdb.AcsService;
import alma.acs.tmcdb.AcsServiceServiceType;
import alma.obops.tmcdbgui.editors.AcsServiceEditor;

public class AcsServiceComposite extends Composite
{
	private AcsService _service;
	/* Widgets */
	private Combo cTypeCombo;
	private Text  cInstanceNameText;
	
	@Override 
	public boolean setFocus()
	{
		return cTypeCombo.setFocus();
	}
	
	// This is a hack to expose these, but the alternative was to have redundant code/widget in both NewAcsServicePage 
	// and AcsServiceEditor. This is the lesser of the evils...
	public Control getTypeControl()
	{
		return this.cTypeCombo;
	}
	
	// This is a hack to expose these, but the alternative was to have redundant code/widget in both NewAcsServicePage 
	// and AcsServiceEditor. This is the lesser of the evils...
	public Control getInstanceNameControl() {
		return this.cInstanceNameText;
	}
	
	public AcsServiceComposite(Composite parent, int mode, AcsService service )
	{
		super(parent, mode);
		this._service = service;
		createControl();
	}
	
	private void createControl()
	{
		setLayout(new FillLayout());
		ScrolledComposite sc = new ScrolledComposite(this, SWT.V_SCROLL | SWT.BORDER);
		sc.setExpandHorizontal(true);
		sc.setExpandVertical(true);

		Composite composite = new Composite(sc, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		/* Type */
		GridData gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label cProcTypeLabel = new Label(composite, SWT.NONE);
		cProcTypeLabel.setText("Service Type");
		cProcTypeLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		Composite c = new Composite(composite, SWT.CHECK);
		c.setLayoutData(gd);
		c.setLayout(new RowLayout());
		cTypeCombo = new Combo(c, SWT.DROP_DOWN | SWT.READ_ONLY );
		cTypeCombo.setData("type", "serviceType");
		cTypeCombo.setItems(AcsServiceEditor.SERVICE_TYPES);
		cTypeCombo.select(0);

		/* Instance Name */
		gd = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		Label cValueLabel = new Label(composite, SWT.NONE);
		cValueLabel.setText("Instance Name: ");
		cValueLabel.setLayoutData(gd);

		gd = new GridData(SWT.FILL, SWT.CENTER, true, false);
		gd.horizontalIndent = 20;
		cInstanceNameText = new Text(composite, SWT.BORDER);
		if(_service.getServiceType().equals(AcsServiceServiceType.NOTIFICATION)) {
			cInstanceNameText.setEnabled(true);
			cInstanceNameText.setText(_service.getServiceInstanceName() != null ? _service.getServiceInstanceName() : "");
		} else {
			cInstanceNameText.setEnabled(false);
		}
		cInstanceNameText.setLayoutData(gd);
		cInstanceNameText.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				_service.setServiceInstanceName(cInstanceNameText.getText());
			}
		});

		// Finally, calculate the minimum size so the scroll composite knows
		// when to start its role
		sc.setContent(composite);
		sc.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		// Listener for option type
		cTypeCombo.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				_service.setServiceType( AcsServiceServiceType.valueOfForEnum(cTypeCombo.getText().trim()) );
				if(_service.getServiceType().equals(AcsServiceServiceType.NOTIFICATION)) {
					cInstanceNameText.setEnabled(true);
				} else {
					cInstanceNameText.setText("");
					cInstanceNameText.setEnabled(false);
				}
			}
		});
	}
}
