/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package alma.obops.tmcdbgui.views.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Taken from:
 * http://dev.eclipse.org/viewcvs/index.cgi/org.eclipse.jface.snippets
 * /Eclipse%20
 * JFace%20Snippets/org/eclipse/jface/snippets/viewers/BooleanCellEditor.java
 * 
 * TODO Replace with "real" fully supported editor when it becomes available
 *      (Eclipse 3.5?)
 * 
 * TODO -- this is probably obsolete by now, remove when we're sure. 
 *         amc, 24-Mar-2009
 * 
 * @since 3.4
 * @author Tom Schindl
 */



public class BooleanCellEditor extends CellEditor {
    private Button button;
    private ViewerRow row;
    private int index;
    private String restoredText;
    private Image restoredImage;

    /**
     * @param parent
     */
    public BooleanCellEditor(Composite parent) {
        super(parent);
    }

    /**
     * @param parent
     * @param style
     */
    public BooleanCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public LayoutData getLayoutData() {
        LayoutData data = super.getLayoutData();
        data.horizontalAlignment=SWT.CENTER;
        data.grabHorizontal = false;
        return data;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();

        button = new Button(parent, getStyle() | SWT.CHECK);
        button.setFont(font);
        button.setBackground(bg);

        button.addKeyListener(new KeyAdapter() {

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.KeyAdapter#keyReleased(org.eclipse.swt.events.KeyEvent)
             */
            public void keyReleased(KeyEvent e) {
                if( e.character == SWT.ESC ) {
                    fireCancelEditor();
                }
            }

        });

        return button;
    }

    protected Object doGetValue() {
        return Boolean.valueOf(button.getSelection());
    }

    protected void doSetValue(Object value) {
        boolean selection = Boolean.TRUE.equals(value);
        button.setSelection(selection);
    }

    protected void doSetFocus() {
        if (button != null) {
            button.setFocus();
        }
    }

    protected void deactivate(ColumnViewerEditorDeactivationEvent event) {
        super.deactivate(event);
        if( event.eventType == ColumnViewerEditorDeactivationEvent.EDITOR_CANCELED ) {
            row.setImage(index, restoredImage);
            row.setText(index, restoredText);
        }
        row = null;
        restoredImage = null;
        restoredText = null;
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        ViewerCell cell = (ViewerCell)activationEvent.getSource();
        index = cell.getColumnIndex();
        row = (ViewerRow) cell.getViewerRow().clone();
        restoredImage = row.getImage(index);
        restoredText = row.getText(index);
        row.setImage(index, null);
        row.setText(index, ""); //$NON-NLS-1$
        super.activate(activationEvent);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.CellEditor#getDoubleClickTimeout()
     */
    protected int getDoubleClickTimeout() {
        return 0;
    }


}

