/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.typedlists;

import java.util.ArrayList;

import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Catch-all for any base elements which don't fit into another category (e.g. new base elements that
 * are introduced into the system, for which the GUI hasn't yet been updated).
 * 
 * @author sharrington
 */
public class BaseElementList extends ArrayList<BaseElement> implements Comparable<BaseElementList>
{
	private static final long serialVersionUID = -3750810834421295180L;
	private HwConfiguration hwConfiguration;
	private BaseElementType type;
	
	public BaseElementList(HwConfiguration hwConfig, BaseElementType type)
	{
		this.hwConfiguration = hwConfig;
		this.type = type;
	}
	
	public BaseElementType getType() {
		return this.type;
	}
	
	public HwConfiguration getHwConfiguration()
	{
		return this.hwConfiguration;
	}

	@Override
	public int compareTo(BaseElementList o) {
		int retVal;
		if(null != this.getType() && null != o.getType()) {
			retVal = this.getType().name().toLowerCase().compareTo(o.getType().name().toLowerCase());
		}
		// some special logic to handle "unknown" base element objects, currently should never
		// go through this code as all be types are known to the GUI presently
		else {
			if(null == this.getType() && null == this.getType()) {
				retVal = 0;
			} else if(null == this.getType() && null != this.getType()) {
				retVal = 1;
			} else {
				retVal = -1;
			}
		}
		return retVal;
	}
}
