/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.typedlists;

import java.util.ArrayList;

import alma.tmcdb.domain.Assembly;
import alma.tmcdb.domain.AssemblyType;
import alma.tmcdb.domain.HwConfiguration;

/**
 * A list of Assemblies sharing a common AssemblyRole
 */



public class AssemblyList extends ArrayList<Assembly> 
{
    private static final long serialVersionUID = -7896547746291547881L;
    private AssemblyType type;
    private HwConfiguration hwConfiguration;

    public AssemblyList( AssemblyType type, HwConfiguration owningConfig ) {
        super();
        this.type = type;
        this.hwConfiguration = owningConfig;
    }

    public AssemblyType getAssemblyType() {
        return type;
    }

	public HwConfiguration getHwConfiguration() {
		return hwConfiguration;
	}

	public int compareTo(Object list2) 
	{
		if(!(list2 instanceof AssemblyList)) {
			return -1;
		}
		int retVal = type.getName().compareTo(((AssemblyList)list2).getAssemblyType().getName());
		return retVal;
	}
}
