/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.startup;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.BaseElementStartup;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Helper for a weather station startup.
 * @author sharring
 */
public class WeatherStationStartupHelper extends BaseElementStartupHelper  
{
	private static Map<BaseElementStartup, WeatherStationStartupHelper> instanceMap = new HashMap<BaseElementStartup, WeatherStationStartupHelper>();
	
	/**
	 * Constructor.
	 * @param beStartup the centralrack startup object which
	 * represents the centralrack domain object, for which this
	 * helper class provides info (e.g. images, text, children,
	 * etc.)
	 */
	public WeatherStationStartupHelper(BaseElementStartup beStartup, HwConfiguration owningConfig)
	{
		super(beStartup, owningConfig);
	}
	
	@Override 
	public Image getFirstColumnImage()
	{
		return RcpUtils.getImage("icons/weatherstation.png");
	}
	
	public synchronized static WeatherStationStartupHelper getInstance(BaseElementStartup baseElementStartup, HwConfiguration owningConfig)
	{
		WeatherStationStartupHelper retVal = instanceMap.get(baseElementStartup);
		
		if(null == retVal) {
			retVal = new WeatherStationStartupHelper(baseElementStartup, owningConfig);
			instanceMap.put(baseElementStartup, retVal);
		}
		
		return retVal;
	}

	public static void clearCache() {
		instanceMap.clear();
	}
}
