/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.startup;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.BaseElementStartup;
import alma.tmcdb.domain.BaseElementStartupType;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Helper class for photonic reference base element startup object.
 * @author sharring
 */
public class PhotonicReferenceStartupHelper extends BaseElementStartupHelper 
{
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance1Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance2Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance3Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance4Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance5Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	private static Map<BaseElementStartup, PhotonicReferenceStartupHelper> instance6Map = new HashMap<BaseElementStartup, PhotonicReferenceStartupHelper>();
	
	/**
	 * Constructor.
	 * @param baseElementStartup the BaseElementStartup domain object
	 * for which this helper class provides info (e.g. images, text, children, 
	 * etc.)
	 */
	private PhotonicReferenceStartupHelper(BaseElementStartup baseElementStartup, HwConfiguration owningConfig) 
	{
		super(baseElementStartup, owningConfig);
	}
	
	public synchronized static PhotonicReferenceStartupHelper getInstance(BaseElementStartup baseElementStartup, BaseElementStartupType type, HwConfiguration owningConfig)
	{
		PhotonicReferenceStartupHelper retVal = null;
		
		switch(type) 
		{
		case PhotonicReference1:
			retVal = instance1Map.get(baseElementStartup);	
			break;
		case PhotonicReference2:
			retVal = instance2Map.get(baseElementStartup);
			break;
		case PhotonicReference3:
			retVal = instance3Map.get(baseElementStartup);
			break;
		case PhotonicReference4:
			retVal = instance4Map.get(baseElementStartup);
			break;
		case PhotonicReference5:
			retVal = instance5Map.get(baseElementStartup);
			break;
		case PhotonicReference6:
			retVal = instance6Map.get(baseElementStartup);
			break;
		default:
			throw new IllegalArgumentException("Illegal value for type of photonic reference");
		}
		
		if(null == retVal) {
			retVal = new PhotonicReferenceStartupHelper(baseElementStartup, owningConfig);
			
			switch(type) 
			{
			case PhotonicReference1:
				instance1Map.put(baseElementStartup, retVal);
				break;
			case PhotonicReference2:
				instance2Map.put(baseElementStartup, retVal);
				break;
			case PhotonicReference3:
				instance3Map.put(baseElementStartup, retVal);
				break;
			case PhotonicReference4:
				instance4Map.put(baseElementStartup, retVal);
				break;
			case PhotonicReference5:
				instance5Map.put(baseElementStartup, retVal);
				break;
			case PhotonicReference6:
				instance6Map.put(baseElementStartup, retVal);
				break;
			default:
				throw new IllegalArgumentException("Illegal value for type of photonic reference");
			}
		}
		
		return retVal;
	}

	@Override
	public Image getFirstColumnImage()
	{
		return RcpUtils.getImage("icons/photonicref.png");
	}
	
	public static void clearCache() {
		instance1Map.clear();
		instance2Map.clear();
		instance3Map.clear();
		instance4Map.clear();
		instance5Map.clear();
		instance6Map.clear();
	}
}
