/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.startup;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.views.providers.typedlists.LRUTypeRole;

/**
 * Helper class for LRUTypeRole object.
 * @author sharrington
 */
public class LRUTypeRoleHelper implements ThreeColumnDomainObjectHelper 
{
    public static final String CHECKED_KEY = "CHECKED";
    public static final String UNCHECK_KEY = "UNCHECKED";
    public static final String DISABLED_CHECKBOX_KEY = "DISABLED_CHECKBOX";
    
	private LRUTypeRole role;
	
	/**
	 * Constructor.
	 * @param role the role for which this helper class provides info
	 * (e.g. images, text, children, etc.)
	 */
	public LRUTypeRoleHelper(LRUTypeRole role)
	{
		this.role = role;
	}
	
	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage( "icons/assembly.png" );
	}

	@Override
	public String getFirstColumnText() {
		return role.getAssemblyRole().getName();
	}

	@Override
	public Image getSecondColumnImage() {
		Image retVal = null;
		if(!role.isEnabled()) {
			retVal = RcpUtils.getImage("icons/checkbox-disabled.png");
		}
		else if( role.isStarted()) {
			retVal = RcpUtils.getImage("icons/checkbox-set.png");
		}
		else {
			retVal = RcpUtils.getImage("icons/checkbox-unset.png");
		}
		return retVal;
	}
	
	@Override
	public Image getThirdColumnImage() {
		Image retVal = null;
		if(!role.isEnabled() || !role.isStarted()) {
			retVal = RcpUtils.getImage("icons/checkbox-disabled.png");
		}
		else if(role.simAndProductionCodeAreSame()) 
		{
			retVal = RcpUtils.getImage("icons/checkbox-equals.png");
		}
		else if( role.isSimulated()) {
			retVal = RcpUtils.getImage("icons/checkbox-set.png");
		}
		else {
			retVal = RcpUtils.getImage("icons/checkbox-unset.png");
		}
		return retVal;
	}
	
	@Override
	public boolean hasChildren() {
		return false;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public Font getFont() {
		if( !role.isEnabled() )
			return JFaceResources.getFontRegistry().getItalic(JFaceResources.DEFAULT_FONT);
		return null;
	}

	@Override
	public Color getForeground() {
		if( !role.isEnabled() ) {
			Color grey = JFaceResources.getColorRegistry().get("grey");
			if( grey == null )
				JFaceResources.getColorRegistry().put("grey", new RGB(200, 200, 200));
			return JFaceResources.getColorRegistry().get("grey");
		}
		return null;
	}
}
