/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.startup;

import java.util.HashMap;
import java.util.Map;

import alma.obops.tmcdbgui.views.providers.helpers.config.ConfigurationHelper;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Helper class for Configuration domain object in the context of 
 * startup tree.
 * 
 * @author sharrington
 */
public class ConfigurationStartupHelper extends ConfigurationHelper 
{
	private static Map<String, ConfigurationStartupHelper> instanceMap = new HashMap<String, ConfigurationStartupHelper>();
	
	/**
	 * Constructor.
	 * @param configuration the configuration of interest/use to this helper.
	 */
	private ConfigurationStartupHelper(HwConfiguration configuration)
	{
		super(configuration);
	}
	
	public synchronized static ConfigurationStartupHelper getInstance(HwConfiguration configuration)
	{
		ConfigurationStartupHelper retVal = instanceMap.get(configuration.getName());
		
		if(retVal == null) {
			ConfigurationStartupHelper newInstance = new ConfigurationStartupHelper(configuration);
			instanceMap.put(configuration.getName(), newInstance);
			retVal = newInstance;
		}
		
		return retVal;
	}
	
	@Override
	public Object[] getChildren() 
	{
		Object [] retVal = new Object[0];
		retVal = configuration.getStartupScenarios().toArray( retVal );
        return retVal;
	}
	
	@Override
	public boolean hasChildren() 
	{
           return configuration.getStartupScenarios().size() > 0;
	}
	
	@Override
	public String getSecondColumnText()
	{
		return null;
	}
	
	@Override
	public String getThirdColumnText()
	{
		return null;
	}

	public static void clearCache() {
		instanceMap.clear();
	}
}
