/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.config;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.tmcdb.domain.PointingModel;

/**
 * Helper class for pointing models.
 * @author sharring
 */
public class PointingModelHelper implements ThreeColumnDomainObjectHelper 
{
	@SuppressWarnings("unused")
	private PointingModel pointingModel;
	
	public PointingModelHelper(PointingModel pm)
	{
		this.pointingModel = pm;
	}
	
	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/pointingmodel.png");
	}

	@Override
	public String getFirstColumnText() {
		return "Pointing model";
	}

	@Override
	public Image getSecondColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getSecondColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getThirdColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

}
