/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.config;

import alma.obops.tmcdbgui.utils.conversation.BaseElementConversationUtils;
import alma.tmcdb.domain.HolographyTower;
import alma.tmcdb.domain.HolographyTowerToPad;

public class HolographyTowerToPadHelper extends HolographyTowerHelper 
{
	private HolographyTowerToPad h2p;
	
	public HolographyTowerToPadHelper(HolographyTowerToPad h2p) 
	{
		super(h2p.getHolographyTower());
		this.h2p = h2p;
	}

	@Override
	public Object[] getChildren() 
	{
		Object[] retVal = null;
		return retVal;
	}
	
	@Override
	public boolean hasChildren() 
	{
		HolographyTower tower = (HolographyTower) baseElement;
		try {
			BaseElementConversationUtils.getInstance().hydrateHolographyTower(tower);
		} catch (Exception ex) {
			throw new RuntimeException("Unable to hydrate holography tower", ex);
		}
		return false;
	}
	
	@Override
	public String getFirstColumnText() {
		String retVal = super.getFirstColumnText();
		if(!this.h2p.getPad().getConfiguration().getId().equals(this.h2p.getHolographyTower().getConfiguration().getId()))
		{
			retVal = retVal + ":" + this.h2p.getHolographyTower().getConfiguration().getName();
		}
		return retVal;
	}
}
