/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.config;

import java.util.Set;

import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.FEDelay;
import alma.tmcdb.domain.IFDelay;
import alma.tmcdb.domain.LODelay;
import alma.tmcdb.domain.Pad;

/**
 * Temporary(?) class to bundle all the delay info for an antenna into a single class.
 * @author sharring
 */
public class DelayModel 
{
	private Antenna antenna;
	private Pad pad;
	
	public DelayModel(Antenna antenna, Pad pad)
	{
		this.antenna = antenna;
		this.pad = pad;
	}
	
	
	public Set<IFDelay> getIfDelays() {
		return antenna.getIfDelays();
	}
	
	public Set<LODelay> getLoDelays() {
		return antenna.getLoDelays();
	}
	
	public Set<FEDelay> getFeDelays() {
		return antenna.getFrontEndDelays();
	}
	
	public Antenna getAntenna() 
	{
		return this.antenna;
	}
	
	public Pad getPad() 
	{
		return this.pad;
	}
	
	@Override
	public boolean equals(Object o) {
		boolean retVal = false;
		if(o == null) {
			retVal = false;
		} 
		else if(!(o instanceof DelayModel)) {
			retVal = false;
		}
		else {
			DelayModel dm2 = (DelayModel) o;
			retVal = this.getAntenna().getId().equals(dm2.getAntenna().getId());
		}
		
		return retVal;
	}
	
	@Override
	public int hashCode()
	{
		int retVal = 17;
		
		retVal = retVal * Integer.valueOf((int)getAntenna().getId().longValue());
		
		return retVal;
	}

}
