/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers.helpers.config;

import alma.tmcdb.domain.AntennaToPad;

/**
 * Helper class for displaying an antenna to pad mapping in the GUI's treeviewer.
 * @author sharring
 */
public class AntennaToPadHelper extends PadHelper {

	private AntennaToPad a2p;
	
	public AntennaToPadHelper(AntennaToPad a2p) {
		super(a2p.getPad());
		this.a2p = a2p;
	}

	@Override
	public Object[] getChildren() {
		Object[] retVal = null;
		return retVal;
	}
	
	@Override
	public boolean hasChildren() {
		return false;
	}
	
	@Override
	public String getFirstColumnText() {
		String retVal = baseElement.getName();
		if(!this.a2p.getPad().getConfiguration().getId().equals(this.a2p.getAntenna().getConfiguration().getId()))
		{
			retVal = retVal + ":" + this.a2p.getPad().getConfiguration().getName();
		}
		return retVal;
	}
}
