/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdbgui.utils.DelayEditingUtils;

/**
 * Label provider for the xp delay editor
 * @author sharring
 *
 */
public class XpDelaysLabelProvider extends LabelProvider implements ITableLabelProvider, ITableFontProvider, ITableColorProvider
{
	@Override
	public Image getColumnImage(Object element, int columnIndex) 
	{
		Image retVal = null;
	
		if( !(element instanceof XpDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			XpDelayModelRow row = (XpDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = row.getUsbBasebandZeroDelayImage();
				break;
			case 2:
				retVal = row.getLsbBasebandZeroDelayImage();
				break;
			case 3:
				retVal = row.getUsbBasebandOneDelayImage();
				break;
			case 4:
				retVal = row.getLsbBasebandOneDelayImage();
				break;
			case 5:
				retVal = row.getUsbBasebandTwoDelayImage();
				break;
			case 6:
				retVal = row.getLsbBasebandTwoDelayImage();
				break;
			case 7:
				retVal = row.getUsbBasebandThreeDelayImage();
				break;
			case 8:
				retVal = row.getLsbBasebandThreeDelayImage();
				break;
			default:
				retVal = null;
			}
		}

		return retVal;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) 
	{
		String retVal = null;
		
		if( !(element instanceof XpDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			XpDelayModelRow row = (XpDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = "Band " + (DelayEditingUtils.getIntFromReceiverBandEnum(row.getBand()) + 1);
				break;
			case 1:
				retVal = row.getUsbBasebandZeroDelay() == null ? "0.0" : String.valueOf(row.getUsbBasebandZeroDelay().getDelay());
				break;
			case 2:
				retVal = row.getLsbBasebandZeroDelay() == null ? "0.0" : String.valueOf(row.getLsbBasebandZeroDelay().getDelay());
				break;
			case 3:
				retVal = row.getUsbBasebandOneDelay() == null ? "0.0" : String.valueOf(row.getUsbBasebandOneDelay().getDelay());
				break;
			case 4:
				retVal = row.getLsbBasebandOneDelay() == null ? "0.0" : String.valueOf(row.getLsbBasebandOneDelay().getDelay());
				break;
			case 5:
				retVal = row.getUsbBasebandTwoDelay() == null ? "0.0" : String.valueOf(row.getUsbBasebandTwoDelay().getDelay());
				break;
			case 6:
				retVal = row.getLsbBasebandTwoDelay() == null ? "0.0" : String.valueOf(row.getLsbBasebandTwoDelay().getDelay());
				break;
			case 7:
				retVal = row.getUsbBasebandThreeDelay() == null ? "0.0" : String.valueOf(row.getUsbBasebandThreeDelay().getDelay());
				break;
			case 8:
				retVal = row.getLsbBasebandThreeDelay() == null ? "0.0" : String.valueOf(row.getLsbBasebandThreeDelay().getDelay());
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}
	
	@Override
	public Font getFont(Object element, int columnIndex) 
	{
		Font retVal = null;

		if( !(element instanceof XpDelayModelRow) ) 
		{
			retVal = null;
		}
		else 
		{
			XpDelayModelRow row = (XpDelayModelRow)element;
			switch(columnIndex) 
			{
			case 0:
				retVal = null;
				break;
			case 1:
				retVal = row.getUsbBasebandZeroDelayFont();
				break;
			case 2:
				retVal = row.getLsbBasebandZeroDelayFont();
				break;
			case 3:
				retVal = row.getUsbBasebandOneDelayFont();
				break;
			case 4:
				retVal = row.getLsbBasebandOneDelayFont();
				break;
			case 5:
				retVal = row.getUsbBasebandTwoDelayFont();
				break;
			case 6:
				retVal = row.getLsbBasebandTwoDelayFont();
				break;
			case 7:
				retVal = row.getUsbBasebandThreeDelayFont();
				break;
			case 8:
				retVal = row.getLsbBasebandThreeDelayFont();
				break;
			default:
				retVal = null;
			}
		}
		return retVal;
	}

	@Override
	public Color getBackground(Object element, int colIndex) {
		return null;
	}

	@Override
	public Color getForeground(Object element, int colIndex) {
		return null;
	}
}
