/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdbgui.views.providers;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.BasebandNameMod.BasebandName;
import alma.NetSidebandMod.NetSideband;
import alma.ReceiverBandMod.ReceiverBand;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.XPDelay;

/**
 * Represents a single row in the table that is used to edit XP (cross polarization) delays.
 * @author sharring
 */
public class XpDelayModelRow 
{
	private ReceiverBand band;
	private XPDelay usbBasebandZeroDelay;
	private XPDelay lsbBasebandZeroDelay;
	private XPDelay usbBasebandOneDelay;
	private XPDelay lsbBasebandOneDelay;
	private XPDelay usbBasebandTwoDelay;
	private XPDelay lsbBasebandTwoDelay;
	private XPDelay usbBasebandThreeDelay;
	private XPDelay lsbBasebandThreeDelay;
	
	private Image usbBasebandZeroDelayImage;
	private Image lsbBasebandZeroDelayImage;
	private Image usbBasebandOneDelayImage;
	private Image lsbBasebandOneDelayImage;
	private Image usbBasebandTwoDelayImage;
	private Image lsbBasebandTwoDelayImage;
	private Image usbBasebandThreeDelayImage;
	private Image lsbBasebandThreeDelayImage;
	
	public Image getLsbBasebandThreeDelayImage() {
		return lsbBasebandThreeDelayImage;
	}

	private Font usbBasebandZeroDelayFont;
	private Font lsbBasebandZeroDelayFont;
	private Font usbBasebandOneDelayFont;
	private Font lsbBasebandOneDelayFont;
	private Font usbBasebandTwoDelayFont;
	private Font lsbBasebandTwoDelayFont;
	private Font usbBasebandThreeDelayFont;
	private Font lsbBasebandThreeDelayFont;
	
	public static final Image CHANGED_IMAGE = PointingModelRow.CHANGED_IMAGE;
	
	public XpDelayModelRow(XPDelay usbBB0Delay, XPDelay lsbBB0Delay, XPDelay usbBB1Delay,
			XPDelay lsbBB1Delay, XPDelay usbBB2Delay, XPDelay lsbBB2Delay,
			XPDelay usbBB3Delay, XPDelay lsbBB3Delay, ReceiverBand bb, HwConfiguration hwconfig)
	{
		this.band = bb;

		if(null == usbBB0Delay) {
			this.usbBasebandZeroDelay = new XPDelay(band, BasebandName.BB_1, NetSideband.USB, 0.0, hwconfig);
		} else {
			this.usbBasebandZeroDelay = usbBB0Delay;
		}

		if(null == lsbBB0Delay) {
			this.lsbBasebandZeroDelay = new XPDelay(band, BasebandName.BB_1, NetSideband.LSB, 0.0, hwconfig);
		} else {
			this.lsbBasebandZeroDelay = lsbBB0Delay;
		}

		if(null == usbBB1Delay) {
			this.usbBasebandOneDelay = new XPDelay(band, BasebandName.BB_2, NetSideband.USB, 0.0, hwconfig);
		} else {
			this.usbBasebandOneDelay = usbBB1Delay;
		}

		if(null == lsbBB1Delay) {
			this.lsbBasebandOneDelay = new XPDelay(band, BasebandName.BB_2, NetSideband.LSB, 0.0, hwconfig);
		} else {
			this.lsbBasebandOneDelay = lsbBB1Delay;
		}

		if(null == usbBB2Delay) {
			this.usbBasebandTwoDelay = new XPDelay(band, BasebandName.BB_3, NetSideband.USB, 0.0, hwconfig);
		} else {
			this.usbBasebandTwoDelay = usbBB2Delay;
		}

		if(null == lsbBB2Delay) {
			this.lsbBasebandTwoDelay = new XPDelay(band, BasebandName.BB_3, NetSideband.LSB, 0.0, hwconfig);
		} else {
			this.lsbBasebandTwoDelay = lsbBB2Delay;
		}

		if(null == usbBB3Delay) {
			this.usbBasebandThreeDelay = new XPDelay(band, BasebandName.BB_4, NetSideband.USB, 0.0, hwconfig);
		} else {
			this.usbBasebandThreeDelay = usbBB3Delay;
		}

		if(null == lsbBB3Delay) {
			this.lsbBasebandThreeDelay = new XPDelay(band, BasebandName.BB_4, NetSideband.LSB, 0.0, hwconfig);
		} else {
			this.lsbBasebandThreeDelay = lsbBB3Delay;
		}
	}
	
	public void setUsbBasebandZeroDelay(XPDelay delay) {
		this.usbBasebandZeroDelay = delay;
	}

	public void setLsbBasebandZeroDelay(XPDelay delay) {
		this.lsbBasebandZeroDelay = delay;
	}

	public void setUsbBasebandOneDelay(XPDelay delay) {
		this.usbBasebandOneDelay = delay;
	}

	public void setLsbBasebandOneDelay(XPDelay delay) {
		this.lsbBasebandOneDelay = delay;
	}

	public void setUsbBasebandTwoDelay(XPDelay delay) {
		this.usbBasebandTwoDelay = delay;
	}

	public void setLsbBasebandTwoDelay(XPDelay delay) {
		this.lsbBasebandTwoDelay = delay;
	}

	public void setUsbBasebandThreeDelay(XPDelay delay) {
		this.usbBasebandThreeDelay = delay;
	}

	public void setLsbBasebandThreeDelay(XPDelay delay) {
		this.lsbBasebandThreeDelay = delay;
	}

	public ReceiverBand getBand() {
		return band;
	}

	public XPDelay getUsbBasebandZeroDelay() {
		return usbBasebandZeroDelay;
	}

	public XPDelay getLsbBasebandZeroDelay() {
		return lsbBasebandZeroDelay;
	}

	public XPDelay getUsbBasebandOneDelay() {
		return usbBasebandOneDelay;
	}

	public XPDelay getLsbBasebandOneDelay() {
		return lsbBasebandOneDelay;
	}

	public XPDelay getUsbBasebandTwoDelay() {
		return usbBasebandTwoDelay;
	}

	public XPDelay getLsbBasebandTwoDelay() {
		return lsbBasebandTwoDelay;
	}

	public XPDelay getUsbBasebandThreeDelay() {
		return usbBasebandThreeDelay;
	}

	public XPDelay getLsbBasebandThreeDelay() {
		return lsbBasebandThreeDelay;
	}

	// Image setters
	public void setLsbBasebandZeroDelayImage(Image image) {
		this.lsbBasebandZeroDelayImage = image;
	}
	
	public void setLsbBasebandOneDelayImage(Image image) {
		this.lsbBasebandOneDelayImage = image;
	}
	
	public void setLsbBasebandTwoDelayImage(Image image) {
		this.lsbBasebandTwoDelayImage = image;
	}
	
	public void setLsbBasebandThreeDelayImage(Image image) {
		this.lsbBasebandThreeDelayImage = image;
	}

	public void setUsbBasebandZeroDelayImage(Image image) {
		this.usbBasebandZeroDelayImage = image;
	}
	
	public void setUsbBasebandOneDelayImage(Image image) {
		this.usbBasebandOneDelayImage = image;
	}
	
	public void setUsbBasebandTwoDelayImage(Image image) {
		this.usbBasebandTwoDelayImage = image;
	}
	
	public void setUsbBasebandThreeDelayImage(Image image) {
		this.usbBasebandThreeDelayImage = image;
	}
	
	// Font setters
	public void setLsbBasebandZeroDelayFont(Font font) {
		this.lsbBasebandZeroDelayFont = font;
	}
	
	public void setLsbBasebandOneDelayFont(Font font) {
		this.lsbBasebandOneDelayFont = font;
	}
	
	public void setLsbBasebandTwoDelayFont(Font font) {
		this.lsbBasebandTwoDelayFont = font;
	}
	
	public void setLsbBasebandThreeDelayFont(Font font) {
		this.lsbBasebandThreeDelayFont = font;
	}

	public void setUsbBasebandZeroDelayFont(Font font) {
		this.usbBasebandZeroDelayFont = font;
	}
	
	public void setUsbBasebandOneDelayFont(Font font) {
		this.usbBasebandOneDelayFont = font;
	}
	
	public void setUsbBasebandTwoDelayFont(Font font) {
		this.usbBasebandTwoDelayFont = font;
	}
	
	public void setUsbBasebandThreeDelayFont(Font font) {
		this.usbBasebandThreeDelayFont = font;
	}
	
	public Image getUsbBasebandZeroDelayImage() {
		return usbBasebandZeroDelayImage;
	}

	public Image getLsbBasebandZeroDelayImage() {
		return lsbBasebandZeroDelayImage;
	}

	public Image getUsbBasebandOneDelayImage() {
		return usbBasebandOneDelayImage;
	}

	public Image getLsbBasebandOneDelayImage() {
		return lsbBasebandOneDelayImage;
	}

	public Image getUsbBasebandTwoDelayImage() {
		return usbBasebandTwoDelayImage;
	}

	public Image getLsbBasebandTwoDelayImage() {
		return lsbBasebandTwoDelayImage;
	}

	public Image getUsbBasebandThreeDelayImage() {
		return usbBasebandThreeDelayImage;
	}

	public Font getUsbBasebandZeroDelayFont() {
		return usbBasebandZeroDelayFont;
	}

	public Font getLsbBasebandZeroDelayFont() {
		return lsbBasebandZeroDelayFont;
	}

	public Font getUsbBasebandOneDelayFont() {
		return usbBasebandOneDelayFont;
	}

	public Font getLsbBasebandOneDelayFont() {
		return lsbBasebandOneDelayFont;
	}

	public Font getUsbBasebandTwoDelayFont() {
		return usbBasebandTwoDelayFont;
	}

	public Font getLsbBasebandTwoDelayFont() {
		return lsbBasebandTwoDelayFont;
	}

	public Font getUsbBasebandThreeDelayFont() {
		return usbBasebandThreeDelayFont;
	}

	public Font getLsbBasebandThreeDelayFont() {
		return lsbBasebandThreeDelayFont;
	}
}